function [msg]=lef2bef(leFile,beFile,datatype)
%[msg]=lef2bef(leFile,beFile,datatype)
%translate little-endian file to big-endian file
%Input:
% leFile: file name of a little-endian file
% beFile: file name of a big-endian file
% datatype: see document of fread()
%Output:
% msg: a short message
%
%20040318, jdlee
%

if(nargin < 3),
  error('not enough input parameters');
end
    
fid = fopen(leFile,'rb','ieee-le');
a = fread(fid,datatype);
fclose(fid);

fid = fopen(beFile,'wb','ieee-be');
fwrite(fid,a,datatype);
fclose(fid);

msg='ok';

return
